/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * {@link ExtensionPoint} hosting the nodetype definitions
 */
public class NodeTypeDefinitionsExtensionPoint extends AbstractLogEnabled implements ExtensionPoint<String>, Component
{
    /** Avalon Role */
    public static final String ROLE = NodeTypeDefinitionsExtensionPoint.class.getName();
    
    private Map<String, String> _nodetypeDefinitions = new HashMap<>();
    
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException
    {
        String nodetypeDef = configuration.getChild("nodetype-definition", true).getValue(null);
        
        // Add the nodetype definition 
        if (nodetypeDef != null)
        {
            if (_nodetypeDefinitions.containsKey(id))
            {
                getLogger().error("The nodetype definition of id " + id + " is already defined. It will be ignored");
            }
            else
            {
                _nodetypeDefinitions.put(id, "plugin:" + pluginName + "://" + nodetypeDef);
            }
        }
    }

    public void initializeExtensions() throws Exception
    {
        // Empty
    }

    @Override
    public boolean hasExtension(String id)
    {
        return _nodetypeDefinitions.containsKey(id);
    }

    @Override
    public String getExtension(String id)
    {
        if (hasExtension(id))
        {
            return _nodetypeDefinitions.get(id);
        }
        return null;
    }

    @Override
    public Set<String> getExtensionsIds()
    {
        return _nodetypeDefinitions.keySet();
    }
    
    /**
     * Returns the declared nodetypes definitions.
     * @return the declared nodetypes definitions.
     */
    public Collection<String> getNodeTypeDefinitions()
    {
        return _nodetypeDefinitions.values();
    }
    
}
