/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * Constants
 */
public interface RepositoryConstants
{
    /** Name of the JCR default workspace */
    public static final String DEFAULT_WORKSPACE = "default";
    
    /** Namespace prefix for properties and node types. */
    public static final String NAMESPACE_PREFIX = "ametys";

    /** Namespace URI for properties and node types. */
    public static final String NAMESPACE_URI = "http://www.ametys.org/jcr/repository/1.0";

    /** Namespace prefix for internal properties * */
    public static final String NAMESPACE_PREFIX_INTERNAL = "ametys-internal";

    /** Namespace URI for internal properties * */
    public static final String NAMESPACE_URI_INTERNAL = "http://www.ametys.org/jcr/repository/internal/1.0";
    
    /** Metadata name for storing a Node's lockToken */
    public static final String METADATA_LOCKTOKEN = NAMESPACE_PREFIX_INTERNAL + ":lockToken";

    /** Metadata name for storing the real lockOwner of a Node */
    public static final String METADATA_LOCKOWNER = NAMESPACE_PREFIX_INTERNAL + ":lockOwner";
    
    /** JCR type for users. */
    public static final String USER_NODETYPE = NAMESPACE_PREFIX + ":user";

    /** JCR type for geocodes. */
    public static final String GEOCODE_NODETYPE = NAMESPACE_PREFIX + ":geocode";

    /** JCR type for multilingual strings. */
    public static final String MULTILINGUAL_STRING_METADATA_NODETYPE = NAMESPACE_PREFIX + ":multilingualString";

    /** JCR type for references. */
    public static final String REFERENCE_NODETYPE = NAMESPACE_PREFIX + ":referenceItem";

    /** JCR type for binaries. */
    public static final String BINARY_NODETYPE = NAMESPACE_PREFIX + ":binaryMetadata";

    /** JCR type for rich texts. */
    public static final String RICH_TEXT_NODETYPE = NAMESPACE_PREFIX + ":richText";

    /** JCR type for complex multiple values parent data. */
    public static final String MULTIPLE_ITEM_NODETYPE = NAMESPACE_PREFIX + ":multipleItem";

    /** JCR type for composites. */
    public static final String COMPOSITE_NODETYPE = NAMESPACE_PREFIX + ":composite";

    /** JCR type for repeaters. */
    public static final String REPEATER_NODETYPE = NAMESPACE_PREFIX + ":repeater";
    
    /** JCR type for composite metadata */
    public static final String COMPOSITE_METADTA_NODETYPE = NAMESPACE_PREFIX + ":compositeMetadata";
    
    /**
     * The request attribute in which the JCR session is stored
     */
    public static final String JCR_SESSION_REQUEST_ATTRIBUTE = "jcr-sessions";
}
