/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * Exception thrown when an attempt to insert or update data results in
 * violation of an integrity constraint.
 */
public class RepositoryIntegrityViolationException extends AmetysRepositoryException
{
    /**
     * Constructs a new data integrity violation exception with the specified
     * detail message.
     * @param message The detail message. 
     */
    public RepositoryIntegrityViolationException(String message)
    {
        super(message);
    }
    
    /**
     * Constructs a new data integrity violation exception with the specified
     * detail message and cause.
     * @param message The detail message.
     * @param cause The cause.
     */
    public RepositoryIntegrityViolationException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Constructs a new data integrity violation exception with the specified
     * cause.
     * @param cause The cause.
     */
    public RepositoryIntegrityViolationException(Throwable cause)
    {
        super(cause);
    }
}
