/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.activities;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.Expression;

/**
 * Helper for implementing {@link ActivityHolder} in JCR.
 */
public final class ActivityHelper
{
    private ActivityHelper()
    {
        // hide constructor
    }
    /**
     * Creates the XPath query corresponding to specified {@link Expression}.
     * The query will include to sort the result by activity date.
     * If no expression is provided, all the activity nodes will be returned
     * @param activityExpression the query predicates. can be null.
     * @return the created XPath query.
     */
    public static String getActivityXPathQuery(Expression activityExpression)
    {
        String predicats = null;
        
        if (activityExpression != null)
        {
            predicats = StringUtils.trimToNull(activityExpression.build());
        }
        
        StringBuilder sb = new StringBuilder();
        sb.append(" //element(*, ametys:activity)");
        if (predicats != null)
        {
            sb.append("[").append(predicats).append("]");
        }
        SortCriteria sort = new SortCriteria();
        sort.addCriterion(ActivityFactory.DATE, false, false);
        
        sb.append(" ").append(sort.build());
        return sb.toString();
    }
}
