/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.activities;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.jcr.RepositoryException;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;

/**
 * {@link AmetysObject} that can store activities
 */
public interface ActivityHolderAmetysObject extends ActivityHolder
{
    /**
     * Returns the activity holder holding the activities
     * @return the activity holder
     * @throws RepositoryException if failed to get activity holder node
     */
    public ActivityHolder getActivityHolder() throws RepositoryException;
    
    public default AmetysObjectIterable<Activity> getActivities() throws RepositoryException
    {
        return getActivityHolder().getActivities();
    }
    
    public default Activity addActivity(ActivityType type, Map<String, Object> parameters, String eventId) throws RepositoryException
    {
        return getActivityHolder().addActivity(type, parameters, eventId);
    }
    
    public default Activity addActivity(ZonedDateTime date, ActivityType type, Map<String, Object> parameters, UserIdentity author, String eventId) throws RepositoryException
    {
        return getActivityHolder().addActivity(date, type, parameters, author, eventId);
    }

}
