/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.activities;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;

/**
 * Factory to create a {@link DefaultActivityHolder}
 */
public class DefaultActivityHolderFactory extends DefaultTraversableAmetysObjectFactory
{
    private CurrentUserProvider _currentUserProvider;
    private ObservationManager _observationManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _currentUserProvider = (CurrentUserProvider) manager.lookup(CurrentUserProvider.ROLE);
        _observationManager = (ObservationManager) manager.lookup(ObservationManager.ROLE);
    }
    
    /**
     * Get the current user using the {@link CurrentUserProvider}
     * @return the current user identity
     */
    public UserIdentity getCurrentUser()
    {
        return _currentUserProvider.getUser();
    }
    
    /**
     * Get the {@link ObservationManager}
     * @return the observation manager
     */
    public ObservationManager getObservationManager()
    {
        return _observationManager;
    }
}
