/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.activities;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * {@link Observer} implementation to store activities
 */
public class StoreActivityObserver extends AbstractLogEnabled implements Observer, Serviceable
{
    /** Event type extension point */
    protected ActivityTypeExtensionPoint _activityTypeExtensionPoint;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _activityTypeExtensionPoint = (ActivityTypeExtensionPoint) serviceManager.lookup(ActivityTypeExtensionPoint.ROLE);
    }
    
    public boolean supports(Event event)
    {
        // Support all events
        return true;
    }
    
    @Override
    public int getPriority()
    {
        return MAX_PRIORITY;
    }
    
    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        for (ActivityType type : _activityTypeExtensionPoint.getActivityTypes(event.getId()))
        {
            if (type.supports(event))
            {
                type.handleEvent(event);
            }
        }
    }
}
