/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.ametysobject;

import java.util.Collection;
import java.util.Optional;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.data.holder.group.Composite;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;

/**
 * {@link AmetysObject} that can handle data.
 */
public interface DataAwareAmetysObject extends AmetysObject, DataHolder
{
    /**
     * Returns the {@link DataHolder} of this {@link AmetysObject}.
     * @return the {@link DataHolder} of this {@link AmetysObject}
     */
    public DataHolder getDataHolder();
    
    public default Composite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException
    {
        return getDataHolder().getComposite(compositePath);
    }
    
    public default boolean hasValue(String dataPath) throws IllegalArgumentException
    {
        return getDataHolder().hasValue(dataPath);
    }
    
    public default boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException
    {
        return getDataHolder().hasValueOrEmpty(dataPath);
    }

    public default Collection<String> getDataNames()
    {
        return getDataHolder().getDataNames();
    }
    
    public default void copyTo(ModifiableDataHolder dataHolder) throws UndefinedItemPathException, BadItemTypeException, UnknownTypeException, NotUniqueTypeException
    {
        copyTo(dataHolder, DataContext.newInstance());
    }
    
    public default void copyTo(ModifiableDataHolder dataHolder, DataContext context) throws UndefinedItemPathException, BadItemTypeException, UnknownTypeException, NotUniqueTypeException
    {
        getDataHolder().copyTo(dataHolder, context);
    }
    
    public default void dataToSAX(ContentHandler contentHandler, String dataPath) throws SAXException
    {
        dataToSAX(contentHandler, dataPath, DataContext.newInstance());
    }
    
    public default void dataToSAX(ContentHandler contentHandler, String dataPath, DataContext context) throws SAXException
    {
        getDataHolder().dataToSAX(contentHandler, dataPath, context);
    }
    
    public default Object dataToJSON(String dataPath)
    {
        return dataToJSON(dataPath, DataContext.newInstance());
    }
    
    public default Object dataToJSON(String dataPath, DataContext context)
    {
        return getDataHolder().dataToJSON(dataPath, context);
    }
    
    public default RepositoryData getRepositoryData()
    {
        return getDataHolder().getRepositoryData();
    }
    
    public default Optional<? extends DataHolder> getParentDataHolder()
    {
        return getDataHolder().getParentDataHolder();
    }
    
    public default DataHolder getRootDataHolder()
    {
        return getDataHolder().getRootDataHolder();
    }
}
