/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.ametysobject;

import java.util.Map;
import java.util.Optional;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.data.type.RepositoryModelItemType;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;

/**
 * Model less {@link AmetysObject} that can handle data.
 */
public interface ModelLessDataAwareAmetysObject extends DataAwareAmetysObject, ModelLessDataHolder
{
    @Override
    public ModelLessDataHolder getDataHolder();
    
    public default ModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getComposite(compositePath);
    }

    public default boolean hasValue(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return DataAwareAmetysObject.super.hasValue(dataPath);
    }
    
    default boolean hasValue(String dataPath, String dataTypeId) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDataHolder().hasValue(dataPath, dataTypeId);
    }

    public default boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return DataAwareAmetysObject.super.hasValueOrEmpty(dataPath);
    }

    public default <T> T getValue(String dataPath) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getValue(dataPath);
    }
    
    public default <T> T getValue(String dataPath, T defaultValue) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getValue(dataPath, defaultValue);
    }

    public default <T> T getValueOfType(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getValueOfType(dataPath, dataTypeId);
    }
    
    public default <T> T getValueOfType(String dataPath, String dataTypeId, T defaultValue) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getValueOfType(dataPath, dataTypeId, defaultValue);
    }
    
    public default boolean isMultiple(String dataPath) throws IllegalArgumentException, UnknownDataException, BadDataPathCardinalityException
    {
        return getDataHolder().isMultiple(dataPath);
    }
    
    public default boolean isMultiple(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownDataException, BadDataPathCardinalityException
    {
        return getDataHolder().isMultiple(dataPath, dataTypeId);
    }
    
    public default RepositoryModelItemType getType(String dataPath) throws IllegalArgumentException, UnknownDataException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getType(dataPath);
    }
    
    public default void dataToSAX(ContentHandler contentHandler, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException
    {
        getDataHolder().dataToSAX(contentHandler, context);
    }
    
    public default Map<String, Object> dataToJSON(DataContext context) throws UnknownTypeException, NotUniqueTypeException
    {
        return getDataHolder().dataToJSON(context);
    }
    
    public default boolean hasDifferences(Map<String, Object> values) throws UnknownTypeException, NotUniqueTypeException
    {
        return getDataHolder().hasDifferences(values);
    }
    
    public default Optional<? extends ModelLessDataHolder> getParentDataHolder()
    {
        return getDataHolder().getParentDataHolder();
    }
    
    public default ModelLessDataHolder getRootDataHolder()
    {
        return getDataHolder().getRootDataHolder();
    }
    
    default ModelItemTypeExtensionPoint getModelItemTypeExtensionPoint()
    {
        return getDataHolder().getModelItemTypeExtensionPoint();
    }
}
