/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.ametysobject;

import java.util.Map;
import java.util.Optional;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider.ExternalizableDataStatus;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.SynchronizationResult;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;

/**
 * Model aware {@link AmetysObject} that can handle modifiable data.
 */
public interface ModifiableModelAwareDataAwareAmetysObject extends ModelAwareDataAwareAmetysObject, ModifiableModelAwareDataHolder, ModifiableAmetysObject
{
    @Override
    public ModifiableModelAwareDataHolder getDataHolder();

    @Override
    public default ModifiableModelAwareComposite getComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getComposite(compositePath);
    }
    
    @Override
    public default ModifiableModelAwareComposite getLocalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getLocalComposite(compositePath);
    }
    
    @Override
    public default ModifiableModelAwareComposite getExternalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getExternalComposite(compositePath);
    }

    @Override
    public default ModifiableModelAwareRepeater getRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getRepeater(repeaterPath);
    }
    
    @Override
    public default ModifiableModelAwareRepeater getLocalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getLocalRepeater(repeaterPath);
    }
    
    @Override
    public default ModifiableModelAwareRepeater getExternalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getExternalRepeater(repeaterPath);
    }

    public default ModifiableModelAwareComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getComposite(compositePath, createNew);
    }
    
    public default ModifiableModelAwareComposite getLocalComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getLocalComposite(compositePath, createNew);
    }
    
    public default ModifiableModelAwareComposite getExternalComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getExternalComposite(compositePath, createNew);
    }

    public default ModifiableModelAwareRepeater getRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getRepeater(repeaterPath, createNew);
    }
    
    public default ModifiableModelAwareRepeater getLocalRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getLocalRepeater(repeaterPath, createNew);
    }
    
    public default ModifiableModelAwareRepeater getExternalRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getExternalRepeater(repeaterPath, createNew);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDataHolder().synchronizeValues(values);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDataHolder().synchronizeValues(values, context);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDataHolder().synchronizeValues(viewItemAccessor, values);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDataHolder().synchronizeValues(viewItemAccessor, values, context);
    }

    public default void setValue(String dataPath, Object value) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDataHolder().setValue(dataPath, value);
    }
    
    public default void setLocalValue(String dataPath, Object localValue) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDataHolder().setLocalValue(dataPath, localValue);
    }
    
    public default void setExternalValue(String dataPath, Object externalValue) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDataHolder().setExternalValue(dataPath, externalValue);
    }
    
    public default void setStatus(String dataPath, ExternalizableDataStatus status) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDataHolder().setStatus(dataPath, status);
    }
    
    public default void removeValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, UnknownDataException, BadDataPathCardinalityException
    {
        getDataHolder().removeValue(dataPath);
    }

    public default void removeLocalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, UnknownDataException, BadDataPathCardinalityException
    {
        getDataHolder().removeLocalValue(dataPath);
    }

    public default void removeExternalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, UnknownDataException, BadDataPathCardinalityException
    {
        getDataHolder().removeExternalValue(dataPath);
    }
    
    default void removeExternalizableMetadataIfExists(String dataPath) throws IllegalArgumentException, BadItemTypeException, UndefinedItemPathException, BadDataPathCardinalityException
    {
        getDataHolder().removeExternalizableMetadataIfExists(dataPath);
    }
    
    public default ModifiableRepositoryData getRepositoryData()
    {
        return getDataHolder().getRepositoryData();
    }

    public default Optional<? extends ModifiableModelAwareDataHolder> getParentDataHolder()
    {
        return getDataHolder().getParentDataHolder();
    }
    
    public default ModifiableModelAwareDataHolder getRootDataHolder()
    {
        return getDataHolder().getRootDataHolder();
    }
}
