/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.ametysobject;

import java.util.Map;
import java.util.Optional;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelLessComposite;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;

/**
 * Model less {@link AmetysObject} that can handle modifiable data.
 */
public interface ModifiableModelLessDataAwareAmetysObject extends ModifiableModelLessDataHolder, ModelLessDataAwareAmetysObject, ModifiableAmetysObject
{
    @Override
    public ModifiableModelLessDataHolder getDataHolder();
    
    @Override
    public default ModifiableModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getComposite(compositePath);
    }
    
    public default ModifiableModelLessComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDataHolder().getComposite(compositePath, createNew);
    }
    
    public default boolean synchronizeValues(Map<String, Object> values) throws UnknownTypeException, NotUniqueTypeException
    {
        return getDataHolder().synchronizeValues(values);
    }

    public default void setValue(String dataPath, Object value) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDataHolder().setValue(dataPath, value);
    }

    public default void setValue(String dataPath, Object value, String dataType) throws IllegalArgumentException, BadItemTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDataHolder().setValue(dataPath, value, dataType);
    }

    public default void removeValue(String dataPath) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDataHolder().removeValue(dataPath);
    }
    
    public default ModifiableRepositoryData getRepositoryData()
    {
        return getDataHolder().getRepositoryData();
    }
    
    public default Optional<? extends ModifiableModelLessDataHolder> getParentDataHolder()
    {
        return getDataHolder().getParentDataHolder();
    }
    
    public default ModifiableModelLessDataHolder getRootDataHolder()
    {
        return getDataHolder().getRootDataHolder();
    }
}
