/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.extractor;

import java.util.Map;

import org.ametys.runtime.model.View;

/**
 * Interface for model aware values extractors
 */
public interface ModelAwareValuesExtractor extends ValuesExtractor
{
    /**
     * Extracts the values of all items
     * This method will create a {@link View} with the items present in the data source
     * @return the values of all items
     * @throws Exception if an error occurs
     */
    public Map<String, Object> extractValues() throws Exception;
    
    /**
     * Extracts the values of all items in the given view
     * @param view the view
     * @return the values of all items in the given view
     * @throws Exception if an error occurs
     */
    public Map<String, Object> extractValues(View view) throws Exception;
}
