/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder;

import java.util.Optional;

import org.ametys.plugins.repository.data.holder.group.ModifiableComposite;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.runtime.model.exception.BadItemTypeException;

/**
 * Interface for modifiable data containers
 */
public interface ModifiableDataHolder extends DataHolder
{
    @Override
    public ModifiableComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException;
    
    /**
     * Retrieves the composite at the given path
     * @param compositePath path of the composite to retrieve
     * @param createNew <code>true</code> to create the composite if it does not exist, <code>false</code> otherwise
     * @return the composite or <code>null</code> if createNew is <code>false</code> and value not exists or is empty
     * @throws IllegalArgumentException if the given composite path is null or empty
     * @throws BadItemTypeException if the stored value at the given path is not a composite
     */
    public ModifiableComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, BadItemTypeException;
    
    /**
     * Removes the stored value of the data at the given path
     * @param dataPath path of the data
     * @throws IllegalArgumentException if the given data path is null or empty
     * @throws BadItemTypeException if the value of the parent of the given path is not an item container
     */
    public void removeValue(String dataPath) throws IllegalArgumentException, BadItemTypeException;
    
    @Override
    public ModifiableRepositoryData getRepositoryData();
    
    @Override
    public Optional<? extends ModifiableDataHolder> getParentDataHolder();
    
    @Override
    public ModifiableDataHolder getRootDataHolder();
}
