/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.Collection;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;

/**
 * Interface for composites
 */
public interface Composite extends DataHolder
{
    @Override
    public default boolean hasValue(String dataPath) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasValue(dataPath);
    }
    
    @Override
    public default boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasValueOrEmpty(dataPath);
    }
    
    @Override
    public default Collection<String> getDataNames()
    {
        return getDefaultDataHolder().getDataNames();
    }
    
    public default void copyTo(ModifiableDataHolder dataHolder, DataContext context) throws UndefinedItemPathException, BadItemTypeException, UnknownTypeException, NotUniqueTypeException
    {
        getDefaultDataHolder().copyTo(dataHolder, context);
    }
    
    public default void dataToSAX(ContentHandler contentHandler, String dataPath, DataContext context) throws SAXException
    {
        getDefaultDataHolder().dataToSAX(contentHandler, dataPath, context);
    }
    
    public default Object dataToJSON(String dataPath, DataContext context)
    {
        return getDefaultDataHolder().dataToJSON(dataPath, context);
    }
    
    /**
     * Retrieves the default implementation of a {@link DataHolder} to use
     * @return the {@link DataHolder}
     */
    public DataHolder getDefaultDataHolder();
}
