/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.data.external.ExternalizableDataProvider.ExternalizableDataStatus;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.type.DataContext;

/**
 * Interface for model aware composites
 */
public interface ModelAwareComposite extends ModelAwareDataHolder, Composite
{
    @Override
    public default ModelAwareComposite getComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath);
    }

    @Override
    public default ModelAwareComposite getLocalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalComposite(compositePath);
    }

    @Override
    public default ModelAwareComposite getExternalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalComposite(compositePath);
    }

    @Override
    public default ModelAwareRepeater getRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getRepeater(repeaterPath);
    }

    @Override
    public default ModelAwareRepeater getLocalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalRepeater(repeaterPath);
    }

    @Override
    public default ModelAwareRepeater getExternalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalRepeater(repeaterPath);
    }

    @Override
    public default <T> T getValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValue(dataPath);
    }

    @Override
    public default <T> T getValue(String dataPath, boolean allowMultiValuedPathSegments) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValue(dataPath, allowMultiValuedPathSegments);
    }

    @Override
    public default <T> T getValue(String dataPath, boolean useDefaultFromModel, T defaultValue) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValue(dataPath, useDefaultFromModel, defaultValue);
    }

    @Override
    public default <T> T getLocalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalValue(dataPath);
    }

    @Override
    public default <T> T getExternalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalValue(dataPath);
    }

    @Override
    public default ExternalizableDataStatus getStatus(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getStatus(dataPath);
    }
    
    public default boolean hasValue(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasValue(dataPath);
    }

    @Override
    public default boolean hasLocalValue(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasLocalValue(dataPath);
    }

    @Override
    public default boolean hasExternalValue(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasExternalValue(dataPath);
    }
    
    @Override
    public default boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasValueOrEmpty(dataPath);
    }

    @Override
    public default boolean hasLocalValueOrEmpty(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasLocalValueOrEmpty(dataPath);
    }

    @Override
    public default boolean hasExternalValueOrEmpty(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasExternalValueOrEmpty(dataPath);
    }

    @Override
    public default Collection< ? extends ModelItemContainer> getModel()
    {
        return getDefaultDataHolder().getModel();
    }

    @Override
    public default ModelItem getDefinition(String path) throws IllegalArgumentException, UndefinedItemPathException
    {
        return getDefaultDataHolder().getDefinition(path);
    }

    @Override
    public default boolean hasDefinition(String path) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasDefinition(path);
    }
    
    @Override
    public default Collection<String> getDataNames()
    {
        return getDefaultDataHolder().getDataNames();
    }
    
    public default void dataToSAX(ContentHandler contentHandler, ViewItemAccessor viewItemAccessor, DataContext context) throws SAXException, BadItemTypeException
    {
        getDefaultDataHolder().dataToSAX(contentHandler, viewItemAccessor, context);
    }
    
    public default void dataToSAXForEdition(ContentHandler contentHandler, ViewItemAccessor viewItemAccessor, DataContext context) throws SAXException, BadItemTypeException
    {
        getDefaultDataHolder().dataToSAXForEdition(contentHandler, viewItemAccessor, context);
    }
    
    public default Map<String, Object> dataToJSON(ViewItemAccessor viewItemAccessor, DataContext context) throws BadItemTypeException
    {
        return getDefaultDataHolder().dataToJSON(viewItemAccessor, context);
    }
    
    public default Map<String, Object> dataToJSONForEdition(ViewItemAccessor viewItemAccessor, DataContext context) throws BadItemTypeException
    {
        return getDefaultDataHolder().dataToJSONForEdition(viewItemAccessor, context);
    }
    
    public default Map<String, Object> dataToMap(ViewItemAccessor viewItemAccessor, DataContext context)
    {
        return getDefaultDataHolder().dataToMap(viewItemAccessor, context);
    }
    
    public default boolean hasDifferences(ViewItemAccessor viewItemAccessor, Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().hasDifferences(viewItemAccessor, values);
    }
    
    public default boolean hasDifferences(ViewItemAccessor viewItemAccessor, Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().hasDifferences(viewItemAccessor, values, context);
    }
    
    public default Collection<ModelItem> getDifferences(ViewItemAccessor viewItemAccessor, Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().getDifferences(viewItemAccessor, values);
    }
    
    public default Collection<ModelItem> getDifferences(ViewItemAccessor viewItemAccessor, Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().getDifferences(viewItemAccessor, values, context);
    }

    @Override
    public default Optional<? extends ModelAwareDataHolder> getParentDataHolder()
    {
        return getDefaultDataHolder().getParentDataHolder();
    }

    @Override
    public default ModelAwareDataHolder getRootDataHolder()
    {
        return getDefaultDataHolder().getRootDataHolder();
    }

    @Override
    public ModelAwareDataHolder getDefaultDataHolder();
}
