/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.type.RepositoryModelItemType;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;

/**
 * Interface for model less composites
 */
public interface ModelLessComposite extends ModelLessDataHolder, Composite
{
    @Override
    public default ModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath);
    }

    @Override
    public default <T> T getValue(String dataPath) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValue(dataPath);
    }

    @Override
    public default <T> T getValue(String dataPath, T defaultValue) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValue(dataPath, defaultValue);
    }

    @Override
    public default <T> T getValueOfType(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValueOfType(dataPath, dataTypeId);
    }

    @Override
    public default <T> T getValueOfType(String dataPath, String dataTypeId, T defaultValue) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getValueOfType(dataPath, dataTypeId, defaultValue);
    }
    
    @Override
    public default boolean hasValue(String dataPath) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasValue(dataPath);
    }
    
    public default boolean hasValue(String dataPath, String dataTypeId) throws IllegalArgumentException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().hasValue(dataPath, dataTypeId);
    }
    
    @Override
    public default boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException
    {
        return getDefaultDataHolder().hasValueOrEmpty(dataPath);
    }

    @Override
    public default boolean isMultiple(String dataPath) throws IllegalArgumentException, UnknownDataException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().isMultiple(dataPath);
    }
    
    public default boolean isMultiple(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownDataException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().isMultiple(dataPath, dataTypeId);
    }

    @Override
    public default RepositoryModelItemType getType(String dataPath) throws IllegalArgumentException, UnknownDataException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getType(dataPath);
    }
    
    @Override
    public default Collection<String> getDataNames()
    {
        return getDefaultDataHolder().getDataNames();
    }
    
    @Override
    public default void dataToSAX(ContentHandler contentHandler, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException
    {
        getDefaultDataHolder().dataToSAX(contentHandler, context);
    }
    
    public default Map<String, Object> dataToJSON(DataContext context) throws UnknownTypeException, NotUniqueTypeException
    {
        return getDefaultDataHolder().dataToJSON(context);
    }
    
    public default boolean hasDifferences(Map<String, Object> values) throws UnknownTypeException, NotUniqueTypeException
    {
        return getDefaultDataHolder().hasDifferences(values);
    }

    @Override
    public default Optional<? extends ModelLessDataHolder> getParentDataHolder()
    {
        return getDefaultDataHolder().getParentDataHolder();
    }

    @Override
    public default ModelLessDataHolder getRootDataHolder()
    {
        return getDefaultDataHolder().getRootDataHolder();
    }

    @Override
    public ModelLessDataHolder getDefaultDataHolder();
}
