/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.Map;
import java.util.Optional;

import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider.ExternalizableDataStatus;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.SynchronizationResult;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;

/**
 * Interface for modifiable model aware composites
 */
public interface ModifiableModelAwareComposite extends ModelAwareComposite, ModifiableComposite, ModifiableModelAwareDataHolder
{
    @Override
    public default ModifiableModelAwareComposite getComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath);
    }
    
    @Override
    public default ModifiableModelAwareComposite getLocalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalComposite(compositePath);
    }
    
    @Override
    public default ModifiableModelAwareComposite getExternalComposite(String compositePath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalComposite(compositePath);
    }

    @Override
    public default ModifiableModelAwareRepeater getRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getRepeater(repeaterPath);
    }
    
    @Override
    public default ModifiableModelAwareRepeater getLocalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalRepeater(repeaterPath);
    }
    
    @Override
    public default ModifiableModelAwareRepeater getExternalRepeater(String repeaterPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalRepeater(repeaterPath);
    }

    public default ModifiableModelAwareComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath, createNew);
    }
    
    public default ModifiableModelAwareComposite getLocalComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalComposite(compositePath, createNew);
    }
    
    public default ModifiableModelAwareComposite getExternalComposite(String compositePath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalComposite(compositePath, createNew);
    }

    public default ModifiableModelAwareRepeater getRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getRepeater(repeaterPath, createNew);
    }
    
    public default ModifiableModelAwareRepeater getLocalRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getLocalRepeater(repeaterPath, createNew);
    }
    
    public default ModifiableModelAwareRepeater getExternalRepeater(String repeaterPath, boolean createNew) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getExternalRepeater(repeaterPath, createNew);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().synchronizeValues(values);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().synchronizeValues(values, context);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().synchronizeValues(viewItemAccessor, values);
    }
    
    public default <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException
    {
        return getDefaultDataHolder().synchronizeValues(viewItemAccessor, values, context);
    }

    public default void setValue(String dataPath, Object value) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setValue(dataPath, value);
    }
    
    public default void setLocalValue(String dataPath, Object localValue) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setLocalValue(dataPath, localValue);
    }
    
    public default void setExternalValue(String dataPath, Object externalValue) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setExternalValue(dataPath, externalValue);
    }
    
    public default void setStatus(String dataPath, ExternalizableDataStatus status) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setStatus(dataPath, status);
    }
    
    public default void removeValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().removeValue(dataPath);
    }
    
    public default void removeLocalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().removeLocalValue(dataPath);
    }
    
    public default void removeExternalValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().removeExternalValue(dataPath);
    }
    
    public default void removeExternalizableMetadataIfExists(String dataPath) throws IllegalArgumentException, BadItemTypeException, UndefinedItemPathException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().removeExternalizableMetadataIfExists(dataPath);
    }
    
    @Override
    public default Optional<? extends ModifiableModelAwareDataHolder> getParentDataHolder()
    {
        return getDefaultDataHolder().getParentDataHolder();
    }
    
    @Override
    public default ModifiableModelAwareDataHolder getRootDataHolder()
    {
        return getDefaultDataHolder().getRootDataHolder();
    }

    @Override
    public ModifiableModelAwareDataHolder getDefaultDataHolder();
}
