/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.List;

import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.SynchronizationResult;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;

/**
 * Interface for modifiable model aware repeaters
 */
public interface ModifiableModelAwareRepeater extends ModelAwareRepeater, ModifiableRepeater
{
    @Override
    public List<? extends ModifiableModelAwareRepeaterEntry> getEntries();
    
    @Override
    public ModifiableModelAwareRepeaterEntry getEntry(int position);
    
    @Override
    public ModifiableModelAwareRepeaterEntry addEntry();
    
    @Override
    public ModifiableModelAwareRepeaterEntry addEntry(int position) throws IllegalArgumentException;
    
    /**
     * Synchronizes the given values with each repeater's entry
     * @param <T> the type of the {@link SynchronizationResult}
     * @param viewItemAccessor The {@link ViewItemAccessor} for all items to synchronize
     * @param repeaterValues the values of the repeater to synchronize
     * @return the {@link SynchronizationResult}
     * @throws UndefinedItemPathException if an entry's key refers to a data that is not defined by the model
     * @throws BadItemTypeException if the type defined by the model of one entry's key doesn't match the corresponding value
     */
    public default <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, SynchronizableRepeater repeaterValues) throws UndefinedItemPathException, BadItemTypeException
    {
        return synchronizeValues(viewItemAccessor, repeaterValues, SynchronizationContext.newInstance());
    }
    
    /**
     * Synchronizes the given values with each repeater's entry
     * @param <T> the type of the {@link SynchronizationResult}
     * @param viewItemAccessor The {@link ViewItemAccessor} for all items to synchronize
     * @param repeaterValues the values of the repeater to synchronize
     * @param context the context of the synchronization
     * @return the {@link SynchronizationResult}
     * @throws UndefinedItemPathException if an entry's key refers to a data that is not defined by the model
     * @throws BadItemTypeException if the type defined by the model of one entry's key doesn't match the corresponding value
     */
    public <T extends SynchronizationResult> T synchronizeValues(ViewItemAccessor viewItemAccessor, SynchronizableRepeater repeaterValues, SynchronizationContext context) throws UndefinedItemPathException, BadItemTypeException;
    
    @Override
    public ModifiableModelAwareDataHolder getParentDataHolder();
    
    @Override
    public ModifiableModelAwareDataHolder getRootDataHolder();
}
