/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

import java.util.Map;
import java.util.Optional;

import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;

/**
 * Interface for modifiable model less composites
 */
public interface ModifiableModelLessComposite extends ModelLessComposite, ModifiableComposite, ModifiableModelLessDataHolder
{
    @Override
    public default ModifiableModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath);
    }

    public default ModifiableModelLessComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException
    {
        return getDefaultDataHolder().getComposite(compositePath, createNew);
    }
    
    public default boolean synchronizeValues(Map<String, Object> values)
    {
        return getDefaultDataHolder().synchronizeValues(values);
    }

    public default void setValue(String dataPath, Object value) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setValue(dataPath, value);
    }

    public default void setValue(String dataPath, Object value, String dataTypeId) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().setValue(dataPath, value, dataTypeId);
    }

    public default void removeValue(String dataPath) throws IllegalArgumentException, UnknownDataException, BadDataPathCardinalityException
    {
        getDefaultDataHolder().removeValue(dataPath);
    }
    
    @Override
    public default Optional<? extends ModifiableModelLessDataHolder> getParentDataHolder()
    {
        return getDefaultDataHolder().getParentDataHolder();
    }
    
    @Override
    public default ModifiableModelLessDataHolder getRootDataHolder()
    {
        return getDefaultDataHolder().getRootDataHolder();
    }

    @Override
    public ModifiableModelLessDataHolder getDefaultDataHolder();
}
