/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group;

/**
 * Interface for modifiable repeater entries
 */
public interface ModifiableRepeaterEntry extends RepeaterEntry, ModifiableComposite
{
    /**
     * Sets the position of the entry in the repeater. The position starts at index 1.
     * The position can be an integer between 1 and the repeater size to move an entry from the beginning
     * Or the position can an integer between 0 and - the repeater size to move an entry from the end (0 means at the end, -1 means before the last one and so on)
     * @param position The new position of the entry
     * @throws IllegalArgumentException if the position is not between the negative and positive repeater size
     */
    public void setPosition(int position) throws IllegalArgumentException;
    
    @Override
    public ModifiableRepeater getHoldingRepeater();
}
