/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group.impl;

import java.util.Optional;

import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;

/**
 * Class for model free composites
 */
public class DefaultModelLessComposite implements ModelLessComposite
{
    /** The repository data of the repeater entry */
    protected RepositoryData _repositoryData;
    
    /** the default implementation of a {@link ModelLessDataHolder} to use */
    protected ModelLessDataHolder _defaultDataHolder;
    
    /**
     * Creates a model free composite
     * @param typeExtensionPoint the extension point to use to get available element types
     * @param parent the parent of the created {@link DataHolder}
     * @param root the root {@link DataHolder}
     * @param repositoryData the repository data to use
     */
    public DefaultModelLessComposite(ModelItemTypeExtensionPoint typeExtensionPoint, RepositoryData repositoryData, ModelLessDataHolder parent, ModelLessDataHolder root)
    {
        _repositoryData = repositoryData;
        _defaultDataHolder = new DefaultModelLessDataHolder(typeExtensionPoint, repositoryData, Optional.of(parent), Optional.of(root));
    }
    
    @Override
    public RepositoryData getRepositoryData()
    {
        return _repositoryData;
    }

    @Override
    public ModelLessDataHolder getDefaultDataHolder()
    {
        return _defaultDataHolder;
    }

    public ModelItemTypeExtensionPoint getModelItemTypeExtensionPoint()
    {
        return getDefaultDataHolder().getModelItemTypeExtensionPoint();
    }
}
