/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.group.impl;

import java.util.Optional;

import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelLessComposite;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.lock.LockableAmetysObject;

/**
 * Class for modifiable model free composites
 */
public class DefaultModifiableModelLessComposite extends DefaultModelLessComposite implements ModifiableModelLessComposite
{
    /** The modifiable repository data of this composite */
    protected ModifiableRepositoryData _modifiableRepositoryData;
    
    /** the default implementation of a {@link ModifiableModelLessDataHolder} to use */
    protected ModifiableModelLessDataHolder _modifiableDefaultDataHolder;
    
    /**
     * Creates a modifiable model free composite
     * @param typeExtensionPoint the extension point to use to get available element types
     * @param repositoryData the repository data to use
     * @param lockableAmetysObject the ametys object that can be locked on data modification
     * @param parent the parent of the created {@link DataHolder}
     * @param root the root {@link DataHolder}
     */
    public DefaultModifiableModelLessComposite(ModelItemTypeExtensionPoint typeExtensionPoint, ModifiableRepositoryData repositoryData, Optional<LockableAmetysObject> lockableAmetysObject, ModifiableModelLessDataHolder parent, ModifiableModelLessDataHolder root)
    {
        super(typeExtensionPoint, repositoryData, parent, root);
        _modifiableRepositoryData = repositoryData;
        _modifiableDefaultDataHolder = new DefaultModifiableModelLessDataHolder(typeExtensionPoint, repositoryData, lockableAmetysObject, Optional.of(parent), Optional.of(root));
    }

    @Override
    public ModifiableModelLessDataHolder getDefaultDataHolder()
    {
        return _modifiableDefaultDataHolder;
    }
    
    @Override
    public ModifiableRepositoryData getRepositoryData()
    {
        return _modifiableRepositoryData;
    }
}
