/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.values;

/**
 * Result of a synchronization
 */
public class SynchronizationResult
{
    private boolean _hasChanged;

    /**
     * Determines if some values have changed during the synchronization
     * @return <code>true</code> if some values have changed during the synchronization, <code>false</code> otherwise
     */
    public boolean hasChanged()
    {
        return _hasChanged;
    }

    /**
     * Set to <code>true</code> if a value hasChanged during the synchronization
     * @param hasChanged <code>true</code> if a value hasChanged during the synchronization, <code>false</code> otherwise
     */
    public void setHasChanged(boolean hasChanged)
    {
        _hasChanged = hasChanged;
    }
    
    /**
     * Aggregate the given result to the current one
     * @param result the result to aggregate to the current one
     */
    public void aggregateResult(SynchronizationResult result)
    {
        if (result != null)
        {
            setHasChanged(hasChanged() || result.hasChanged());
        }
    }
}
