/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.holder.values;

import java.util.Optional;

import org.ametys.plugins.repository.data.external.ExternalizableDataProvider.ExternalizableDataStatus;

/**
 * Object that gives some context for data in data holder manipulations
 */
public class ValueContext
{
    private Optional<ExternalizableDataStatus> _status = Optional.empty();
    
    /**
     * Creates a new instance of a {@link ValueContext}
     */
    protected ValueContext()
    {
        // Empty constructor
    }
    
    /**
     * Creates a new instance of a {@link ValueContext}
     * @return the created instance
     */
    public static ValueContext newInstance()
    {
        return new ValueContext();
    }
    
    /**
     * Retrieves the status of the data to set
     * @return the data status
     */
    public Optional<ExternalizableDataStatus> getStatus()
    {
        return _status;
    }
    
    /**
     * Set the status of the data to set
     * @param status the data status to set
     * @return the current {@link ValueContext}
     */
    public ValueContext withStatus(ExternalizableDataStatus status)
    {
        _status = Optional.ofNullable(status);
        return this;
    }
}
