/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.type;

import org.ametys.runtime.model.type.ModelItemType;

/**
 * Extension point holding all {@link ModelItemType} classes for needing features.
 */
public class ModelItemTypeExtensionPoint extends org.ametys.core.model.type.ModelItemTypeExtensionPoint
{
    /** Avalon Role for model aware data basic types */
    public static final String ROLE_MODEL_AWARE_BASIC = ModelItemTypeExtensionPoint.class.getName() + ".ModelAwareBasic";

    /** Avalon Role for model less data basic types */
    public static final String ROLE_MODEL_LESS_BASIC = ModelItemTypeExtensionPoint.class.getName() + ".ModelLessBasic";

    /** Avalon Role for unversioned data types */
    public static final String ROLE_UNVERSIONED = ModelItemTypeExtensionPoint.class.getName() + ".Unversioned";
}
