/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.data.type;

import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;

/**
 * Interface for types of elements stored in the repository
 * @param <T> Type of the element value
 */
public interface RepositoryElementType<T> extends ElementType<T>, RepositoryModelItemType
{
    /**
     * Read the value in the given repository data
     * @param parentData repository data containing the value
     * @param name the name of the element to read
     * @return the value. Can return a T or a T[]. That's why the return type is Object
     * @throws BadItemTypeException if the reading value doesn't match this element type
     */
    public Object read(RepositoryData parentData, String name) throws BadItemTypeException;
    
    /**
     * Write the value into the given repository data
     * @param parentData repository where to store the value.
     * @param name the name of the element to write
     * @param value the value to write. Can be a T or a T[]. That's why it is an Object
     * @throws BadItemTypeException If the given value doesn't match this element type
     */
    public void write(ModifiableRepositoryData parentData, String name, Object value) throws BadItemTypeException;
    
    /**
     * Converts the given externalizable value into JSON object
     * @param value the value to convert
     * @param context The context of the data to convert
     * @return the converted externalizable value
     */
    public default Object externalizableValueToJSON(Object value, DataContext context)
    {
        return valueToJSONForClient(value, context);
    }
}
