/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.dispatcher;

import java.util.Map;

import org.apache.cocoon.environment.Request;

import org.ametys.core.ui.dispatcher.DispatchRequestProcess;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.provider.AmetysSession;

/**
 * Close the JCR Sessions.
 */
public class JCRSessionDispatchRequestProcess implements DispatchRequestProcess
{
    @Override
    public void preProcess(Request request)
    {
        request.removeAttribute(RepositoryConstants.JCR_SESSION_REQUEST_ATTRIBUTE);
    }
    
    @Override
    public void postProcess(Request request)
    {
        @SuppressWarnings("unchecked")
        Map<String, AmetysSession> sessions = (Map<String, AmetysSession>) request.getAttribute(RepositoryConstants.JCR_SESSION_REQUEST_ATTRIBUTE);

        if (sessions != null)
        {
            for (AmetysSession session : sessions.values())
            {
                session.forceLogout();
            }
        }

        request.removeAttribute(RepositoryConstants.JCR_SESSION_REQUEST_ATTRIBUTE);
    }
}
