/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.dom;

import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.CompositeMetadata.MetadataType;

/**
 * DOM layer for a USER metadata
 */
public class UserMetadataElement extends CompositeMetadataElement
{
    /**
     * Constructor.
     * @param metadata the underlying {@link CompositeMetadata}.
     * @param name the name of underlying {@link CompositeMetadata}
     */
    public UserMetadataElement(CompositeMetadata metadata, String name)
    {
        super(metadata, name, null);
    }

    /**
     * Constructor.
     * @param metadata the underlying {@link CompositeMetadata}.
     * @param name the name of underlying {@link CompositeMetadata}
     * @param parent the parent {@link Element}.
     */
    public UserMetadataElement(CompositeMetadata metadata, String name, CompositeMetadataElement parent)
    {
        super(metadata, name, parent);
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> result = new HashMap<>();
        result.put("name", new AmetysAttribute("name", "name", null, _name, this));
        result.put("type", new AmetysAttribute("type", "type", null, MetadataType.USER.toString(), this));
        return result;
    }
    
    @Override
    public Node getFirstChild()
    {
        UserIdentity user = _object.getUser(_name, null);
        if (user != null)
        {
            return new MetadataElement("login", _object.getCompositeMetadata(_name), this);
        }
        
        return null;
    }
}
