/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.dublincore;

import java.util.Date;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Interface for ametys objects which can contain Dublin Core metadata.
 */
public interface DublinCoreAwareAmetysObject extends AmetysObject
{
    
    /**
     * Get the Dublin Core title.
     * @return the Dublin Core title. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCTitle() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core creator.
     * @return the Dublin Core creator. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCCreator() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core subject.
     * @return the Dublin Core subject. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String[] getDCSubject() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core description.
     * @return the Dublin Core description. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCDescription() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core publisher.
     * @return the Dublin Core publisher. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCPublisher() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core contributor.
     * @return the Dublin Core contributor. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCContributor() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core date.
     * @return the Dublin Core date. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    Date getDCDate() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core type.
     * @return the Dublin Core type. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCType() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core format.
     * @return the Dublin Core format. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCFormat() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core identifier.
     * @return the Dublin Core identifier. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCIdentifier() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core source.
     * @return the Dublin Core source. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCSource() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core language.
     * @return the Dublin Core language. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCLanguage() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core relation.
     * @return the Dublin Core relation. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCRelation() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core coverage.
     * @return the Dublin Core coverage. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCCoverage() throws AmetysRepositoryException;
    
    /**
     * Get the Dublin Core rights.
     * @return the Dublin Core rights. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getDCRights() throws AmetysRepositoryException;
    
}
