/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.dublincore;

import java.util.Date;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;

/**
 * Interface for ametys objects which can contain Dublin Core metadata.
 */
public interface ModifiableDublinCoreAwareAmetysObject extends DublinCoreAwareAmetysObject, ModifiableAmetysObject
{
    /**
     * Set the Dublin Core title.
     * @param title the Dublin Core title to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCTitle(String title) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core creator.
     * @param creator the Dublin Core creator to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCCreator(String creator) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core subject.
     * @param subject the Dublin Core subject to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCSubject(String[] subject) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core description.
     * @param description the Dublin Core description to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCDescription(String description) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core publisher.
     * @param publisher the Dublin Core publisher to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCPublisher(String publisher) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core contributor.
     * @param contributor the Dublin Core contributor to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCContributor(String contributor) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core date.
     * @param date the Dublin Core date to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCDate(Date date) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core type. You can use a constant from org.ametys.plugins.repository.dublincore.DCMITypes.
     * @param type the Dublin Core type to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCType(String type) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core format.
     * @param format the Dublin Core format to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCFormat(String format) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core identifier.
     * @param identifier the Dublin Core identifier to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCIdentifier(String identifier) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core source.
     * @param source the Dublin Core source to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCSource(String source) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core language.
     * @param language the Dublin Core language to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCLanguage(String language) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core relation.
     * @param relation the Dublin Core relation to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCRelation(String relation) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core coverage.
     * @param coverage the Dublin Core coverage to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCCoverage(String coverage) throws AmetysRepositoryException;
    
    /**
     * Set the Dublin Core rights.
     * @param rights the Dublin Core rights to set. Can be null.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setDCRights(String rights) throws AmetysRepositoryException;
}
