/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.engine;

import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.core.engine.BackgroundEngineHook;
import org.ametys.core.engine.BackgroundEnvironment;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.provider.AmetysSession;

/**
 * Hook used to release the sessions associated with an environment
 */
public class RepositoryBackgroundEngineHook implements BackgroundEngineHook, Component
{
    @Override
    public void onEnteringEnvironment(Map<String, Object> environmentInformation)
    {
        // nothing to do
    }
    
    @Override
    public void onLeavingEnvironment(Map<String, Object> environmentInformation)
    {
        BackgroundEnvironment environment = (BackgroundEnvironment) environmentInformation.get("environment");
        Request request = ObjectModelHelper.getRequest(environment.getObjectModel());
        
        @SuppressWarnings("unchecked")
        Map<String, AmetysSession> sessions = (Map<String, AmetysSession>) request.getAttribute(RepositoryConstants.JCR_SESSION_REQUEST_ATTRIBUTE);
        
        if (sessions != null)
        {
            for (AmetysSession session : sessions.values())
            {
                session.forceLogout();
            }
        }
    }
}
