/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;

/**
 * Default implementation of an {@link JCRAmetysObjectFactory}, handling
 * {@link DefaultAmetysObject}.<br>
 */
public class DefaultAmetysObjectFactory extends SimpleAmetysObjectFactory
{
    private CurrentUserProvider _currentUserProvider;
    private ModelItemTypeExtensionPoint _unversionedDataTypeExtensionPoint;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _currentUserProvider = (CurrentUserProvider) manager.lookup(CurrentUserProvider.ROLE);
        _unversionedDataTypeExtensionPoint = (ModelItemTypeExtensionPoint) manager.lookup(ModelItemTypeExtensionPoint.ROLE_UNVERSIONED);
    }
    
    @Override
    @SuppressWarnings("unchecked")
    public DefaultAmetysObject getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException
    {
        return new DefaultAmetysObject(node, parentPath, this);
    }

    @Override
    protected Node getWorkspaceNode(SimpleAmetysObject object)
    {
        return ((DefaultAmetysObject) object).getBaseNode();
    }
    
    /**
     * Provides the current user.
     * @return the login of the current user.
     */
    public UserIdentity getCurrentUser()
    {
        return _currentUserProvider.getUser();
    }
    
    /**
     * Retrieves the extension point with available data types for unversioned data
     * @return the extension point with available data types for unversioned data
     */
    public ModelItemTypeExtensionPoint getUnversionedDataTypeExtensionPoint()
    {
        return _unversionedDataTypeExtensionPoint;
    }
}
