/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.avalon.framework.service.ServiceException;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObjectFactory} handling {@link DefaultLockableAmetysObject}.<br>
 */
public class DefaultLockableAmetysObjectFactory extends DefaultAmetysObjectFactory
{
    private LockComponent _lockComponent;
    
    @Override
    @SuppressWarnings("unchecked")
    public DefaultLockableAmetysObject getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException
    {
        return new DefaultLockableAmetysObject(node, parentPath, this);
    }
    
    LockComponent getLockComponent()
    {
        // lazy initialization to prevent chicken/egg scenario on startup
        if (_lockComponent == null)
        {
            try
            {
                _lockComponent = (LockComponent) _manager.lookup(LockComponent.ROLE);
            }
            catch (ServiceException e)
            {
                throw new AmetysRepositoryException("Caught an exception while retrieving LockComponent", e);
            }
        }
        
        return _lockComponent;
    }
}
