/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.jcr;

import java.util.Collection;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObjectFactory} manipulating objects backed by concrete JCR nodes.
 * @param <A> the actual type of {@link AmetysObject}s
 */
public interface JCRAmetysObjectFactory<A extends AmetysObject> extends AmetysObjectFactory<A>
{
    /**
     * Retrieves an {@link AmetysObject} with the provided JCR Session, given its id.<br>
     * Id are like <code>&lt;protocol&gt;://&lt;protocol-specific-part&gt;</code>.
     * @param id the identifier.
     * @param session the JCR Session to use to retrieve the {@link AmetysObject}.
     * @return the corresponding {@link AmetysObject}.
     * @throws AmetysRepositoryException if an error occurs.
     * @throws RepositoryException if a JCR error occurs.
     */
    A getAmetysObjectById(String id, Session session) throws AmetysRepositoryException, RepositoryException;

    /**
     * Creates a {@link AmetysObject} from a persistent JCR node.
     * @param node the JCR node to use.
     * @param parentPath the parent Path in the Ametys hierarchy,
     *        may be <code>null</code> if not known yet.
     * @return the object.
     * @throws AmetysRepositoryException if an error occurs.
     * @throws RepositoryException if a JCR error occurs.
     */
    A getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException;

    /**
     * Returns the nodetypes of the {@link Node} associated with this factory.
     * @return the nodetypes of the {@link Node}.
     */
    Collection<String> getNodetypes();
}
