/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.jcr;

import javax.management.MBeanAttributeInfo;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.stats.RepositoryStatistics.Type;

import org.ametys.core.mbean.AbstractAmetysDynamicMBean;
import org.ametys.plugins.repository.provider.AbstractRepository;
import org.ametys.plugins.repository.provider.JackrabbitRepository;

/**
 * Provide information on JackRabbit real-time performance and usage
 */
public class JackrabbitMBean extends AbstractAmetysDynamicMBean implements Serviceable
{
    /** the ROLE of the component */
    public static final String ROLE = JackrabbitMBean.class.getName();

    /** The jackRabbit repository */
    private JackrabbitRepository _jackRepo;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _jackRepo = (JackrabbitRepository) manager.lookup(AbstractRepository.ROLE);
    }
    
    @Override
    protected Object _getAttribute(String attributeName)
    {
        // Call the corresponding getter for a recognized attribute_name
        if (attributeName.equals("QueryCount"))
        {
            return _jackRepo.getRepositoryStatistics().getTimeSeries(Type.QUERY_COUNT).getValuePerMinute()[0];
        } 
        if (attributeName.equals("QueryAverageDuration"))
        {
            return _jackRepo.getRepositoryStatistics().getTimeSeries(Type.QUERY_AVERAGE).getValuePerMinute()[0];
        }
        if (attributeName.equals("QueryTotalDuration"))
        {
            return _jackRepo.getRepositoryStatistics().getTimeSeries(Type.QUERY_DURATION).getValuePerMinute()[0];
        }
        if (attributeName.equals("SessionCount"))
        {
            return _jackRepo.getRepositoryStatistics().getTimeSeries(Type.SESSION_COUNT).getValuePerMinute()[0];
        }
        return null;
    }

    @Override
    protected String getMBeanName()
    {
        return StringUtils.substringBefore(StringUtils.substringAfterLast(ROLE, "."), "MBean");
    }

    @Override
    protected String getMBeanDescription()
    {
        return "JackRabbit performance information";
    }

    @Override
    protected MBeanAttributeInfo[] getMBeanAttributes()
    {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[4];
        attributes[0] = new MBeanAttributeInfo("QueryCount", "Long", "Number of queries executed the last minute", true, false, false);
        attributes[1] = new MBeanAttributeInfo("QueryTotalDuration", "Long", "Total time spent evaluating queries in milli seconds the last minute", true, false, false);
        attributes[2] = new MBeanAttributeInfo("QueryAverageDuration", "Long", "Average time spent evaluating queries in milli seconds the last minute", true, false, false);
        attributes[3] = new MBeanAttributeInfo("SessionCount", "Long", "Number of currently logged in sessions the last minute", true, false, false);

        return attributes;
    }

}
