/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.lock;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObject} that knows about its lock status.
 */
public interface LockAwareAmetysObject extends AmetysObject
{
    /**
     * Returns true if this {@link AmetysObject} is locked
     * @return true if this {@link AmetysObject} is locked
     * @throws AmetysRepositoryException if a problem occurs
     */
    public boolean isLocked() throws AmetysRepositoryException;

    /**
     * Returns the owner of the lock, or null if none
     * @return the owner of the lock, or null if none
     * @throws AmetysRepositoryException if a problem occurs
     */
    public UserIdentity getLockOwner() throws AmetysRepositoryException;
}
