/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.lock;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Helper for {@link LockAwareAmetysObject}
 *
 */
public final class LockHelper
{
    private LockHelper()
    {
        // Private
    }
    
    /**
     * Determines if the login is the same as the owner of the lock
     * @param object The lockable Ametys object
     * @param user The user to test
     * @return true if the login is the same as the owner of the lock
     * @throws AmetysRepositoryException if a problem occurs
     */
    public static boolean isLockOwner (LockAwareAmetysObject object, UserIdentity user) throws AmetysRepositoryException
    {
        UserIdentity lockOwner = object.getLockOwner();
        return lockOwner == null && user == null || lockOwner != null && lockOwner.equals(user);
    }
}
