/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.lock;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObject} that can be locked.
 */
public interface LockableAmetysObject extends LockAwareAmetysObject
{
    /**
     * Locks this {@link AmetysObject}
     * @throws AmetysRepositoryException if a problem occurs
     */
    public void lock() throws AmetysRepositoryException;

    /**
     * Unlocks this {@link AmetysObject}
     * @throws AmetysRepositoryException if a problem occurs
     */
    public void unlock() throws AmetysRepositoryException;
    
    /**
     * Sets a lock info on the current context for this object
     * @throws AmetysRepositoryException if an error occurs
     */
    public void setLockInfoOnCurrentContext() throws AmetysRepositoryException;
}
