/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.maintenance;

import org.ametys.plugins.repository.provider.AmetysPersistenceManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.PluginsManager.Status;

/**
 * Client side element for maintenance tasks. Checks the safe mode, the status of safe-mode and JDNI nature of repository
 */
public class MaintenanceTaskClientSideElement extends org.ametys.workspaces.repository.maintenance.ui.MaintenanceTaskClientSideElement
{
    @Override
    protected I18nizableText getUnavailableDescription()
    {
        if (!PluginsManager.getInstance().isSafeMode())
        {
            // Maintenance tasks are only available in safe-mode
            return new I18nizableText("plugin.repository", "PLUGINS_REPOSITORY_BUTTON_MAINTENANCE_TASK_NO_SAFE_MODE_DESC");
        }
        else if (PluginsManager.getInstance().getStatus() != Status.SAFE_MODE_FORCED)
        {
            // Maintenance tasks are not available if configuration is not complete
            return new I18nizableText("plugin.repository", "PLUGINS_REPOSITORY_BUTTON_MAINTENANCE_TASK_SAFE_MODE_UNFORCED_DESC");
        }
        else
        {
            return super.getUnavailableDescription();
        }
    }
    
    @Override
    protected boolean isJndi()
    {
        // In safe mode the repository is not started, use the configuration parameter to determine if it is JNDI 
        return Config.getInstance().getValue(AmetysPersistenceManager.CONFIG_USE_DEFAULT) == null;
    }
}
