/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.maintenance;

import javax.jcr.UnsupportedRepositoryOperationException;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

import org.ametys.plugins.repository.provider.AmetysRepository;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;

/**
 * This manager overrides the standalone manager to do specific in safe-mode (repository is not started)
 *
 */
public class MaintenanceTaskManager extends org.ametys.workspaces.repository.maintenance.MaintenanceTaskManager
{
    @Override
    protected AbstractMaintenanceTask _createTask(MaintenanceTaskType type)
    {
        switch (type)
        {
            case REMOVE_INCOHERENT_REFERENCES:
                return new CleanReferenceTask();
            case RECLAIM_UNUSED_SPACE:
                return new ReclaimUnusedSpaceTask();
            default:
                return super._createTask(type);
        }
    }
    
    @Override
    protected Pair<RepositoryConfig, RepositoryContext> _getRepositoryInfo() throws ConfigurationException, UnsupportedRepositoryOperationException
    {
        final RepositoryConfig repositoryConfig;
        final RepositoryContext repositoryContext;
        
        if (_repositoryProvider == null)
        {
            repositoryConfig = _createRepositoryConfig();
            repositoryContext = null;
        }
        else if (_repositoryProvider.getRepository() instanceof AmetysRepository ametysRepository)
        {
            if (!_runningTask.requiresOffline())
            {
                repositoryConfig = null;
                repositoryContext = ametysRepository.getContext();
            }
            else
            {
                MaintenanceTaskType type = _runningTaskType;
                _runningTaskType = null;
                throw new UnsupportedRepositoryOperationException("A maintenance task of type " + type + " can not be run on an online repository");
            }
        }
        else
        {
            _runningTaskType = null;
            throw new UnsupportedRepositoryOperationException("A maintenance task can not be run on an online repository instance of " + _repositoryProvider.getRepository().getClass().getName());
        }
        return Pair.of(repositoryConfig, repositoryContext);
    }

}
