/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata;

import java.util.Collection;

import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Interface representing a folder.
 * @deprecated org.ametys.cms.data.RichText new class doesn't use folder anymore
 */
@Deprecated
public interface Folder
{   
    /**
     * Returns the folder name.
     * @return the folder name.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getName() throws AmetysRepositoryException;
    
    /**
     * Returns a Collection containing all subfolders of this folder.
     * @return a Collection containing all subfolders of this folder.
     * @throws AmetysRepositoryException if an error occurs
     */
    public Collection<? extends Folder> getFolders() throws AmetysRepositoryException;
    
    /**
     * Returns the folder with the specified name.
     * @param folderName the name of the folder.
     * @return the folder with the specified name.
     * @throws UnknownMetadataException if the folder does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Folder getFolder(String folderName) throws UnknownMetadataException, AmetysRepositoryException;
    
    /**
     * Returns a Collection containing all files of this folder.
     * @return a Collection containing all files of this folder.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Collection<? extends File> getFiles() throws AmetysRepositoryException;
    
    /**
     * Tests the existence of a file.
     * @param fileName the name of the file.
     * @return true if the specified file exists in this folder.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public boolean hasFile(String fileName) throws AmetysRepositoryException;
    
    /**
     * Returns the file with the specified name.
     * @param fileName the name of the file.
     * @return the file with the specified name.
     * @throws UnknownMetadataException if the folder does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public File getFile(String fileName) throws UnknownMetadataException, AmetysRepositoryException;
}
