/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata;

import java.util.Date;
import java.util.Locale;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;

/**
 * Modifiable {@link CompositeMetadata}.
 * @deprecated Use {@link ModifiableRepositoryData} instead
 */
@Deprecated
public interface ModifiableCompositeMetadata extends CompositeMetadata
{
    /**
     * Rename the current metadata
     * @param newName the new name
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void rename(String newName) throws AmetysRepositoryException;
    
    /**
     * Removes the given metadata.
     * @param metadataName metadata name.
     * @throws UnknownMetadataException if the metadata does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void removeMetadata(String metadataName) throws UnknownMetadataException, AmetysRepositoryException;

    /**
     * Returns the named metadata's value as {@link BinaryMetadata}.<br> 
     * If the metadata does not exist and createNew is <code>false</code>, an {@link UnknownMetadataException} is thrown.
     * Otherwise, the metadata is automatically created.
     * @param metadataName the metadata name.
     * @param createNew <code>true</code> to create automatically the {@link BinaryMetadata} when missing.
     * @return the metadata value as BinaryMetadata.
     * @throws UnknownMetadataException if the named metadata does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public ModifiableBinaryMetadata getBinaryMetadata(String metadataName, boolean createNew) throws UnknownMetadataException, AmetysRepositoryException;
    
    public ModifiableBinaryMetadata getBinaryMetadata(String metadataName) throws UnknownMetadataException, AmetysRepositoryException;

    /**
     * Returns the named metadata's value as {@link RichText}.<br> 
     * If the metadata does not exist and createNew is <code>false</code>, an {@link UnknownMetadataException} is thrown.
     * Otherwise, the metadata is automatically created.
     * @param metadataName the metadata name.
     * @param createNew <code>true</code> to create automatically the {@link BinaryMetadata} when missing.
     * @return the metadata value as RichText.
     * @throws UnknownMetadataException if the named metadata does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public ModifiableRichText getRichText(String metadataName, boolean createNew) throws UnknownMetadataException, AmetysRepositoryException;

    public ModifiableRichText getRichText(String metadataName) throws UnknownMetadataException, AmetysRepositoryException;

    @Override
    public ModifiableCompositeMetadata getCompositeMetadata(String metadataName) throws UnknownMetadataException, AmetysRepositoryException;

    /**
     * Returns the named metadata's value as {@link CompositeMetadata}.<br> 
     * If the metadata is multi-valued, one of the value is returned.<br>
     * If the metadata does not exist and createNew is <code>false</code>, an {@link UnknownMetadataException} is thrown. Otherwise, the metadata is automatically created.
     * @param metadataName the metadata name.
     * @param createNew <code>true</code> to create automatically the {@link CompositeMetadata} when missing.
     * @return the metadata value as {@link CompositeMetadata}.
     * @throws UnknownMetadataException if the named metadata does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public ModifiableCompositeMetadata getCompositeMetadata(String metadataName, boolean createNew) throws UnknownMetadataException, AmetysRepositoryException;

    @Override
    ModifiableTraversableAmetysObject getObjectCollection(String metadataName) throws AmetysRepositoryException;
    
    /**
     * Returns an object collection metadata as a {@link TraversableAmetysObject}<br>.
     * If the metadata does not exist and createNew is <code>false</code>, an {@link UnknownMetadataException} is thrown. Otherwise, the metadata is automatically created.
     * @param metadataName the metadata name.
     * @param createNew <code>true</code> to create automatically the {@link CompositeMetadata} when missing.
     * @return the metadata as a {@link TraversableAmetysObject}.
     * @throws UnknownMetadataException if the named metadata does not exist.
     * @throws AmetysRepositoryException if an error occurs.
     */
    ModifiableTraversableAmetysObject getObjectCollection(String metadataName, boolean createNew) throws AmetysRepositoryException;
    
    /**
     * Set a string metadata.
     * @param metadataName the metadata name.
     * @param value the String value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, String value) throws AmetysRepositoryException;
    
    /**
     * Set a multilingual string metadata.
     * @param metadataName the metadata name.
     * @param value the String value of this metadata in the given locale.
     * @param locale The value of locale
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, String value, Locale locale) throws AmetysRepositoryException;

    /**
     * Set a date metadata.
     * @param metadataName the metadata name.
     * @param value the Date value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, Date value) throws AmetysRepositoryException;

    /**
     * Set a long metadata.
     * @param metadataName the metadata name.
     * @param value the integer value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, long value) throws AmetysRepositoryException;

    /**
     * Set a double metadata.
     * @param metadataName the metadata name.
     * @param value the integer value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, double value) throws AmetysRepositoryException;

    /**
     * Set a boolean metadata.
     * @param metadataName the metadata name.
     * @param value the boolean value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, boolean value) throws AmetysRepositoryException;
    
    /**
     * Set a {@link UserIdentity} metadata.
     * @param metadataName the metadata name.
     * @param value the {@link UserIdentity} value of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, UserIdentity value) throws AmetysRepositoryException;

    /**
     * Set a multi-valued string metadata.
     * @param metadataName the metadata name.
     * @param values the String array containing values of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, String[] values) throws AmetysRepositoryException;

    /**
     * Set a multi-valued date metadata.
     * @param metadataName the metadata name.
     * @param values the Date array containing values of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, Date[] values) throws AmetysRepositoryException;

    /**
     * Set a multi-valued long metadata.
     * @param metadataName the metadata name.
     * @param values the integer array containing values of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, long[] values) throws AmetysRepositoryException;

    /**
     * Set a multi-valued double metadata.
     * @param metadataName the metadata name.
     * @param values the integer array containing values of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, double[] values) throws AmetysRepositoryException;

    /**
     * Set a multi-valued boolean metadata.
     * @param metadataName the metadata name.
     * @param values the boolean array containing values of this metadata.
     * @throws AmetysRepositoryException if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, boolean[] values) throws AmetysRepositoryException;
    
    /**
     * Set a multi-valued {@link UserIdentity} metadata.
     * @param metadataName the metadata name.
     * @param values the {@link UserIdentity} array containing values of this metadata.
     * @throws AmetysRepositoryException  if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, UserIdentity[] values) throws AmetysRepositoryException;
    
    /**
     * Set a {@link MultilingualString} metadata.
     * @param metadataName the metadata name.
     * @param value the {@link MultilingualString} value
     * @throws AmetysRepositoryException  if the metadata cannot be set.
     */
    public void setMetadata(String metadataName, MultilingualString value) throws AmetysRepositoryException;
}
