/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.metadata;

import java.util.Collection;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;

/**
 * Folder that is not read only
 * @deprecated org.ametys.cms.data.RichText new class doesn't use folder anymore
 */
@Deprecated
public interface ModifiableFolder extends Folder
{
    public Collection<ModifiableFolder> getFolders() throws AmetysRepositoryException;
    
    public ModifiableFolder getFolder(String folderName) throws UnknownMetadataException, AmetysRepositoryException;
    
    public Collection<ModifiableFile> getFiles() throws AmetysRepositoryException;
    
    public ModifiableFile getFile(String fileName) throws UnknownMetadataException, AmetysRepositoryException;

    /**
     * Add a folder with the specified name in this folder.
     * @param folderName the folder name.
     * @return the created folder.
     * @throws RepositoryIntegrityViolationException if a file
     *         or a folder already exists with the given name.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public ModifiableFolder addFolder(String folderName) throws RepositoryIntegrityViolationException, AmetysRepositoryException;
    
    /**
     * Add a file with the specified name in this folder.
     * @param fileName the file name.
     * @return the created file.
     * @throws RepositoryIntegrityViolationException if a file
     *         or a folder already exists with the given name.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public ModifiableFile addFile(String fileName) throws RepositoryIntegrityViolationException, AmetysRepositoryException;
    
    /**
     * Removes the sub-element represented by the specified name.
     * @param name the name of the folder or file to be removed.
     * @throws UnknownMetadataException if no folder nor file does exists.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void remove(String name) throws UnknownMetadataException, AmetysRepositoryException;
    
    /**
     * Removes all files and folders in this folder.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void removeAll() throws AmetysRepositoryException;
}
