/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Resource that is modifiable
 * @deprecated Use org.ametys.cms.data.Resource instead
 */
@Deprecated
public interface ModifiableResource extends Resource
{
    /**
     * Rename the current metadata
     * @param newName the new name
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void rename(String newName) throws AmetysRepositoryException;
    
    /**
     * Set the mime type.
     * @param mimeType the mime type of the data.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setMimeType(String mimeType) throws AmetysRepositoryException;
    
    /**
     * Returns an OuputStream to write the data stream.
     * @return an OuputStream to write the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public OutputStream getOutputStream() throws AmetysRepositoryException;
    
    /**
     * Set the data stream.
     * @param stream the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setInputStream(InputStream stream) throws AmetysRepositoryException;
    
    /**
     * Set the encoding if the data stream, if it is a character stream.
     * @param encoding the encoding of the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setEncoding(String encoding) throws AmetysRepositoryException;

    /**
     * Set the last modification date.
     * @param lastModifiedDate the last modification date.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setLastModified(Date lastModifiedDate) throws AmetysRepositoryException;
}
