/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.metadata;

import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Rich text that is modifiable
 * @deprecated Use org.ametys.cms.data.RichText instead
 */
@Deprecated
public interface ModifiableRichText extends RichText, ModifiableResource
{
    /**
     * Returns the Folder holding additional data.<br>
     * Its internal organization is application dependant.
     * @return the Folder holding additional data
     */
    public ModifiableFolder getAdditionalDataFolder();
    
    /**
     * Add a value to a semantic annotation
     * @param name The name of the annotation
     * @param value The value to append
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void addAnnotation(String name, String value) throws AmetysRepositoryException;
    
    /**
     * Add values to a semantic annotation
     * @param name The name of the annotation
     * @param values The values to append
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void addAnnotation(String name, String[] values) throws AmetysRepositoryException;
    
    /**
     * Return all semantic annotations 
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void removeAnnotations() throws AmetysRepositoryException;
    
    /**
     * Remove a given semantic annotation
     * @param name The name of the semantic association to remove 
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void removeAnnotation(String name) throws AmetysRepositoryException;
    
}
