/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata;

import java.io.InputStream;
import java.util.Date;

import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * Interface representing a binary resource.
 * @deprecated Use org.ametys.cms.data.Resource instead
 */
@Deprecated
public interface Resource
{
    /**
     * Returns the data mime-type.
     * @return the data mime-type.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getMimeType() throws AmetysRepositoryException;
    
    /**
     * Returns the data stream.
     * @return the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public InputStream getInputStream() throws AmetysRepositoryException;
    
    /**
     * Returns the length of the data stream.
     * @return the length of the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public long getLength() throws AmetysRepositoryException;
        
    /**
     * Returns the encoding if the data stream, if it is a character stream.
     * @return the encoding if the data stream or <code>null</code> if not available.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getEncoding() throws AmetysRepositoryException;
    
    /**
     * Returns the last modification date.
     * @return the last modification date.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Date getLastModified() throws AmetysRepositoryException;
}
