/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.UnknownDataException;

/**
 * Exception thrown when an attempt to retrieve a metadata failed because
 * this data does not exist.
 * @deprecated Use {@link UnknownDataException} instead
 */
@Deprecated
public class UnknownMetadataException extends AmetysRepositoryException
{
    /**
     * Constructs a new unknown metadata exception with the specified
     * detail message.
     * @param message The detail message. 
     */
    public UnknownMetadataException(String message)
    {
        super(message);
    }
    
    /**
     * Constructs a new unknown metadata exception with the specified
     * detail message and cause.
     * @param message The detail message.
     * @param cause The cause.
     */
    public UnknownMetadataException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Constructs a new unknown metadata exception with the specified
     * cause.
     * @param cause The cause.
     */
    public UnknownMetadataException(Throwable cause)
    {
        super(cause);
    }
}
