/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.jackrabbit.JcrConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.metadata.BinaryMetadata;
import org.ametys.plugins.repository.metadata.ModifiableBinaryMetadata;

/**
 * JCR based implementation of a {@link BinaryMetadata} based on the ametys:binaryMetadata nodetype
 * @deprecated Use org.ametys.cms.data.Binary instead
 */
@Deprecated
public class JCRBinaryMetadata extends JCRResource implements ModifiableBinaryMetadata
{
    private static Logger __logger = LoggerFactory.getLogger(JCRBinaryMetadata.class);
    
    /**
     * Creates a Node-based binary metadata
     * @param node the support Node
     */
    public JCRBinaryMetadata(Node node)
    {
        super(node);
    }

    public String getFilename()
    {
        try
        {
            return getNode().getProperty("ametys:filename").getString();
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }

    public void setFilename(String filename)
    {
        try
        {
            getNode().setProperty("ametys:filename", filename);
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
    
    public String getHash()
    {
        try
        {
            return getNode().getProperty(RepositoryConstants.NAMESPACE_PREFIX_INTERNAL + ":hash").getString();
        }
        catch (RepositoryException e)
        {
            return null;
        }
    }
    
    @Override
    public void setInputStream(InputStream stream) throws AmetysRepositoryException
    {
        try
        {
            _checkLock();
            Binary binary = getNode().getSession().getValueFactory().createBinary(stream);
            getNode().setProperty(JcrConstants.JCR_DATA, binary);
            
            try (InputStream binaryStream = binary.getStream())
            {
                String sha1Hex = DigestUtils.sha1Hex(binaryStream);
                getNode().setProperty(RepositoryConstants.NAMESPACE_PREFIX_INTERNAL + ":hash" , sha1Hex);
            }
            catch (IOException e)
            {
                __logger.warn("An error occurred setting the hash of binary", e);
            }
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
    
    @Override
    public OutputStream getOutputStream() throws AmetysRepositoryException
    {
        return new JCROutputStream(getNode(), true);
    }
}
