/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.util.Text;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.metadata.ModifiableFile;

/**
 * Java binding of a nt:file JCR Node.<p>
 * {@link Text#escapeIllegalJcrChars(String)} is used for
 * escaping invalid JCR characters or character sequences.
 * @deprecated org.ametys.cms.data.RichText new class doesn't use folder anymore
 */
@Deprecated
public class JCRFile implements ModifiableFile
{
    private Node _node;
    
    /**
     * Constructor
     * @param node the nt:file Node
     */
    public JCRFile(Node node)
    {
        _node = node;
    }
    
    /**
     * Retrieves the underlying node.
     * @return the underlying node.
     */
    public Node getNode()
    {
        return _node;
    }
    
    @Override
    public String getName() throws AmetysRepositoryException
    {
        try
        {
            return Text.unescapeIllegalJcrChars(_node.getName());
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
    
    public JCRResource getResource() throws AmetysRepositoryException
    {
        try
        {
            Node resourceNode = null;
            
            if (_node.hasNode(JcrConstants.JCR_CONTENT))
            {
                // Already exists
                resourceNode = _node.getNode(JcrConstants.JCR_CONTENT);
            }
            else
            {
                resourceNode = _node.addNode(JcrConstants.JCR_CONTENT, JcrConstants.NT_RESOURCE);
            }
            
            return new JCRResource(resourceNode);
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
}
