/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.jackrabbit.JcrConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.ametys.plugins.repository.RepositoryConstants;

/**
 * @deprecated org.ametys.cms.data.Resource new class doesn't use JCROutputStream anymore
 */
@Deprecated
class JCROutputStream extends ByteArrayOutputStream
{
    private static Logger __logger = LoggerFactory.getLogger(JCROutputStream.class);

    private Node _node;
    private boolean _storeHash;
    
    JCROutputStream(Node node, boolean storeHash)
    {
        _node = node;
        _storeHash = storeHash;
    }

    @Override
    public void close() throws IOException
    {
        super.close();

        try
        {
            Binary binary = _node.getSession().getValueFactory().createBinary(new ByteArrayInputStream(toByteArray()));
            _node.setProperty(JcrConstants.JCR_DATA, binary);
            
            if (_storeHash)
            {
                try (InputStream binaryStream = binary.getStream())
                {
                    String sha1Hex = DigestUtils.sha1Hex(binaryStream);
                    
                    _node.setProperty(RepositoryConstants.NAMESPACE_PREFIX_INTERNAL + ":hash" , sha1Hex);
                }
                catch (IOException e)
                {
                    __logger.warn("An error occurred setting the hash of binary", e);
                }
            }
        }
        catch (RepositoryException e)
        {
            throw new IOException("Cannot save primary content", e);
        }
    }
}
